***Exercise 6.2  Postnatal-depression data


use postnatal, clear

* 1.
reshape long dep, i(subj) j(month)
mvdecode dep pre, mv(-9)

xtset subj month
xtdescribe if dep<.

* 2.
generate time = month - 1
* Unstructured
xtmixed dep pre group time || subj:, noconstant ///
   residuals(unstructured, t(month)) mle
estimates store un

* 3.
* Exchangeable
xtmixed dep pre group time || subj:, noconstant ///
   residuals(exchangeable) mle
estimates store exch
lrtest exch un

* 4.
* RI
xtmixed dep pre group time || subj:, mle variance
estimates store ri
display sqrt(14.48409 +11.20199)
display 14.48409/(14.48409 +11.20199)
 
* 5.
* RI & AR(1)
xtmixed dep pre group time || subj:, residuals(ar 1, t(month)) mle
estimates store ri_ar1
lrtest ri_ar1 ri

* 6.
* Toeplitz
xtmixed dep pre group time || subj:, noconstant ///
   residuals(toeplitz 5, t(month)) mle
estimates store toep
lrtest toep ri_ar1, force
lrtest toep ri, force  /* or exchangeable */
lrtest toep un

* 7.
* RC
xtmixed dep pre group time || subj: time, covariance(unstructured) mle
estimates store rc
lrtest rc ri

* 8.
* RC & AR(1)
xtmixed dep pre group time || subj: time,  covariance(unstructured) ///
   residuals(ar 1, t(time)) mle
estimates store rc_ar1
lrtest rc_ar1 rc 
lrtest rc_ar1 ri_ar1
lrtest rc_ar1 ri
 
 * 9.
* Comparison
estimates stats un exch ri ri_ar1 toep rc rc_ar1 


