***Exercise 7.1 Growth in math achievement data

* 1.
use reading, clear
reshape long read math age, i(id) j(grade)
egen mn_math = mean(math), by(grade minority)
twoway (connected mn_math grade if minority==1, sort lpatt(solid)) ///
   (connected mn_math grade if minority==0, sort lpatt(dash)), xtitle(Grade) ///
   ytitle(Mean math score) legend(order(1 "Minority" 2 "Majority"))

* 2.
xtmixed math minority grade || id: grade, cov(unstr) mle ///
   variance residual(independent, by(grade))

* 3.
xtmixed math i.minority##c.grade || id: grade , cov(unstr) mle ///
   variance residual(independent, by(grade))

* 4.
predict fixed, xb
twoway (connected fixed grade if minority==1, sort lpatt(solid)) ///
   (connected fixed grade if minority==0, sort lpatt(dash)), xtitle(Grade) ///
   ytitle(Fitted mean math score) legend(order(1 "Minority" 2 "Majority"))

* 5.
predict traj, fitted
twoway (line traj grade, sort) (connected math grade, sort lpatt(dash)) ///
   if id<15900, by(id, legend(off))
graph export ex6_1_3.eps, replace

* 6.
use reading, clear

sem (math0 <- L1@1 L2@0 _cons@0) /// 
    (math1 <- L1@1 L2@1 _cons@0) /// 
	(math2 <- L1@1 L2@2 _cons@0) /// 
	(math3 <- L1@1 L2@3 _cons@0), ///
	means(L1 L2) method(mlmv)
	 

sem (L1 -> math0@1 math1@1 math2@1 math3@1) ///
    (L2 -> math1@1 math2@2 math3@3), ///
	means(L1 L2) nocons method(mlmv)
	
	
