set more off
capture log close
log using ar1-1, replace
use ${ITSUS_DATA}/monthly, clear
keep date fncc30 pmms30
describe
keep if fncc30!=. & pmms30!=.
tsset
tsline pmms30 fncc30
summarize pmms30 fncc30 D.pmms30 D.fncc30
graph export AR1_levels.eps, replace
generate pssp30 = 100 * (pmms30 - fncc30)
label variable pssp30 "30-year primary and secondary spread"
summarize pssp30
tsline pssp30, yline(44)
graph export AR1_spread.eps, replace
runtest pssp30
regress pmms30 fncc30
predict resid, resid
scatter resid L.resid
graph export AR1_scatter.eps, replace
estat dwatson
estat durbinalt
estat bgodfrey
/* OLS strategy */
newey pmms30 fncc30, lag(1)
predict ols
predict ores, resid
label variable ols OLS
label variable ores OLS
/* Transformation strategy */
regress pmms30 L.pmms30 fncc30 L.fncc30
predict transform
predict tres, resid
label variable transform Transformation
label variable tres Transformation
estat durbinalt
nl (pmms30 = ({b0}*(1-{rho})) + {rho}*L.pmms30 + {b1}*fncc30 - {b1}*{rho}*L.fncc30) in 2/l
/* FGLS strategy */
prais pmms30 fncc30
predict fgls
predict fres, resid
label variable fgls FGLS
label variable fres FGLS
tsline ols transform fgls, lpattern(solid dash longdash_dot)
graph export AR1_compare.eps, replace
*tsline ores tres fres, lpattern(solid dash longdash_dot)
log close
