set more off
capture log close
log using ar1-mdl1, replace
clear
set obs 120
set seed 762
generate eta = rnormal()
generate epsilon = rnormal()*sqrt(1/0.19) in f
replace epsilon = eta + 0.9*epsilon[_n-1] in 2/l
generate x = rnormal()
generate y = 5 + 3*x + epsilon
generate int t = _n
tsset t
save ar1-mdl1, replace
/*
	Test for autocorrelation
*/
regress y x
estat durbinalt
estat vce
/*
	OLS strategy
*/
newey y x, lag(1)
estat durbinalt, force
estat vce
/*
	Transformation strategy
*/
regress y L.y x L.x
estat durbinalt
estat vce
nlcom _b[_cons]/(1-_b[L.y])
nlcom (rho1: _b[L.y]) (rho2: -_b[L.x]/_b[x]), post
test _b[rho1] = _b[rho2]
nl (y = ({b0}*(1-{rho})) + {rho}*L.y + {b1}*x - {b1}*{rho}*L.x) in 2/l
/*
	FGLS strategy
*/
prais y x
estat vce
corc y x
log close
