set more off
capture log close
log using ar1-mdl2, replace
clear
set obs 120
set seed 63
generate eta = rnormal()
generate epsilon = eta
generate x = rnormal()
generate y = (5 + 3*x)/(1-0.9) + epsilon in f
replace y = 5 + 0.9*y[_n-1] + 3*x + epsilon in 2/l
generate int t = _n
tsset t
save ar1-mdl2, replace
/*
	Test for autocorrelation
*/
regress y L.y x
estat durbinalt
estat vce
/*
	OLS strategy
*/
newey y L.y x, lag(1)
estat durbinalt, force
estat vce
/*
	Transformation strategy
*/
regress y L.y L2.y x L.x
estat durbinalt
estat vce
nl (y = ({b0}*(1-{rho})) + ({rho}+{alpha})*L.y - {rho}*{alpha}*L2.y + {b1}*x - {b1}*{rho}*L.x) in 3/l
log close
