set more off
capture log close
log using ar1-mdl3, replace
clear
set obs 120
set seed 51
generate eta = rnormal()
generate epsilon = eta in f
replace epsilon = eta + 0.9*epsilon[_n-1] in 2/l
generate x = rnormal()
generate y = (5 + 3*x)/0.1 + epsilon in f
replace y = 5 + 0.9*y[_n-1] + 3*x + epsilon in 2/l
generate int t = _n
tsset t
save ar1-mdl3, replace
/*
	Test for autocorrelation
*/
regress y L.y x
estat durbinalt
estat vce
/*
	OLS strategy
*/
newey y L.y x, lag(1)
estat durbinalt, force
estat vce
/*
	Transformation strategy
*/
regress L(0/2).y L(0/1).x
estat durbinalt
estat vce
nl (y = ({rho}+{alpha})*L.y - {rho}*{alpha}*L2.y + (1-{rho})*{b0} + {b1}*x - {rho}*{b1}*L.x) in 3/l
/*
	IV strategy
*/
ivregress liml y x (L.y = L.x)
ivregress gmm y x (L.y = L.x), wmatrix(hac bartlett 1) 
ivregress gmm y x (L.y = L.x), wmatrix(hac bartlett opt) 
log close
