clear
capture log close
log using bj-1, replace
/*
	AR(1)
*/
set obs 100 
generate int period = _n
label variable period Period
for any 1 5 9 : generate yX = 1 in f
for any 1 5 9 : replace yX = 0.X*yX[_n-1] in 2/l
for any 1 5 9 : label variable yX "phi = 0.X"
two line y* period in f/20, yline(0.5) lpattern(solid dash longdash_dot)
graph export BJ_ar1decay.eps, replace
drop y*
for any 1 5 9 : generate yX = 1 in f
for any 1 5 9 : replace yX = -0.X*yX[_n-1] in 2/l
for any 1 5 9 : label variable yX "phi = -0.X"
two line y* period in f/20, yline(-0.5 0 0.5) lpattern(solid dash longdash_dot)
graph export BJ_nar1decay.eps, replace
/*
	AR(2)
*/
clear
set obs 100 
generate int period = _n - 1
label variable period Period
generate y = 0 in f
replace y = 1 in 2
local a = 0.85
local b = -0.9
local c = 1.0
qroots, a(`a') b(`b') c(`c')
local p1 = -(`b')
local p2 = -(`a')
replace y = (`p1'*y[_n-1]) + (`p2'*y[_n-2]) in 3/l
two line y period in 2/60, yline(-0.5 0 0.5)
graph export BJ_ar2decay.eps, replace
/*
	Cleanup
*/
log close
