clear
set more off
capture log close
log using coint-1, replace
/*
	Unit root tests

	Real GDP
*/
use ${ITSUS_DATA}/quarterly, clear
generate lgdp = log(gdp2005)
dfuller lgdp, lags(4) reg
dfuller lgdp, lags(4) drift
dfgls lgdp, maxlag(4) notrend
pperron lgdp
/*
	Unit root vs. AR(1)
*/
clear
set obs 200
set seed 53
generate n = _n
tsset n, generic
generate e = rnormal()
generate rw = e in f
replace rw = rw[_n-1] + e in 2/l
ac rw, title(Random walk) name(rw, replace)
dfuller rw, noconstant
dfgls rw, maxlag(0) notrend
pperron rw, noconstant
generate ar = e in f
replace ar = 0.9*L.ar + e in 2/l
correlate rw ar
ac ar, title("AR(1), phi_1=0.9") name(ar, replace)
graph combine rw ar
graph export COINT_accomp.eps, replace
dfuller ar, noconstant
dfgls ar, maxlag(0) notrend
pperron ar, noconstant
generate aralt = e in f
replace aralt = 0.999*L.aralt + e in 2/l
correlate rw aralt
ac aralt, title("AR(1), phi_1=0.999") name(aralt, replace)
graph export COINT_acalt.eps, replace
dfuller aralt, noconstant
dfgls aralt, maxlag(0) notrend
pperron aralt, noconstant

log close
