set more off
clear
capture log close
log using coint-2, replace
/*
	Construction wages example
*/
capture erase wages.irf
/*	
	Look at data
*/
use ${ITSUS_DATA}/conwages, clear
tsset
describe
tsline conwgdc conwgmd conwgva, lpattern(solid dash longdash_dot)
graph export COINT_wagelevels.eps, replace
correlate conwgdc conwgmd conwgva
/*
	Create normalized wage indices (1990:1 = 100)
*/
generate dcwage = 100 * conwgdc/conwgdc[1]
generate mdwage = 100 * conwgmd/conwgmd[1]
generate vawage = 100 * conwgva/conwgva[1]
label variable dc "DC"
label variable md "MD"
label variable va "VA"
format dcwage mdwage vawage %6.0fc
tsline dcwage mdwage vawage, lpattern(solid dash longdash_dot) ytitle(Wage indices)
graph export COINT_wages.eps, replace
/*
	Is there a unit root?
*/
ac vawage
graph export COINT_acva.eps, replace
dfgls vawage
dfuller vawage, trend lags(4)
/*
	How many lags?
*/
varsoc dcwage mdwage vawage
varsoc dcwage mdwage vawage, maxlag(8)
/*
	Boil the ocean: All the combinations of vecrank tests
*/
vecrank dcwage mdwage vawage					/* Default */
vecrank dcwage mdwage vawage, max ic lags(1) trend(trend)	/* Case 1: Unrestricted trend */
vecrank dcwage mdwage vawage, max ic lags(2) trend(trend)
vecrank dcwage mdwage vawage, max ic lags(3) trend(trend)
vecrank dcwage mdwage vawage, max ic lags(1) trend(rtrend)	/* Case 2: Restricted trend */
vecrank dcwage mdwage vawage, max ic lags(2) trend(rtrend)
vecrank dcwage mdwage vawage, max ic lags(3) trend(rtrend)
vecrank dcwage mdwage vawage, max ic lags(1) trend(constant)	/* Case 3: Unrestricted constant */
vecrank dcwage mdwage vawage, max ic lags(2) trend(constant)
vecrank dcwage mdwage vawage, max ic lags(3) trend(constant)
vecrank dcwage mdwage vawage, max ic lags(1) trend(rconstant)	/* Case 4: Restricted constant */
vecrank dcwage mdwage vawage, max ic lags(2) trend(rconstant)
vecrank dcwage mdwage vawage, max ic lags(3) trend(rconstant)
vecrank dcwage mdwage vawage, max ic lags(1) trend(none)	/* Case 5: No trend */
vecrank dcwage mdwage vawage, max ic lags(2) trend(none)
vecrank dcwage mdwage vawage, max ic lags(3) trend(none)
/*
	Estimate the VECMs
*/
vec dcwage mdwage vawage, rank(2) lags(3) trend(trend)
estimates store trendlags3
test [D_dcwage]_trend [D_mdwage]_trend [D_vawage]_trend
test [D_dcwage]_cons [D_mdwage]_cons [D_vawage]_cons
test [D_dcwage]_trend [D_mdwage]_trend [D_vawage]_trend [D_dcwage]_cons [D_mdwage]_cons [D_vawage]_cons
quietly vec dcwage mdwage vawage, rank(2) lags(3) trend(rtrend)
estimates store rtrendlags3
lrtest trendlags3 rtrendlags3

quietly vec dcwage mdwage vawage, rank(2) lags(3) trend(constant)
estimates store constantlags3
lrtest rtrendlags3 constantlags3

vec dcwage mdwage vawage, rank(2) lags(3) trend(rtrend)

quietly vec dcwage mdwage vawage, rank(2) lags(3) trend(rconstant)
estimates store rconstantlags3
lrtest constantlags3 rconstantlags3
lrtest rtrendlags3 rconstantlags3

quietly vec dcwage mdwage vawage, rank(2) lags(3) trend(none)
estimates store nonelags3
lrtest rconstantlags3 nonelags3

quietly vec dcwage mdwage vawage if date>=tq(1990:4), rank(2) lags(2) trend(rconstant)
estimates store rconstantlags2
lrtest rconstantlags3 rconstantlags2

quietly vec dcwage mdwage vawage if date>=tq(1990:4), rank(2) lags(1) trend(rconstant)
estimates store rconstantlags1
lrtest rconstantlags2 rconstantlags1

vec dcwage mdwage vawage if date>=tq(1990:4), rank(2) lags(1) trend(rconstant)
estimates store final
lrtest rtrendlags3 final

/*
constraint 1 [D_dcwage]L1._ce2=0
constraint 2 [D_mdwage]L1._ce1=0
vec dcwage mdwage vawage, rank(2) lags(1) trend(rconstant) aconstraints(1/2)
constraint 3 [_ce1]dcwage=1
constraint 4 [_ce1]mdwage=0
constraint 5 [_ce2]dcwage=0
constraint 6 [_ce2]mdwage=1
vec dcwage mdwage vawage, rank(2) lags(1) trend(rconstant) aconstraints(1/2) bconstraints(3/6)
estimates store final
lrtest rtrendlags3 final
*/

/*
	Tests of the residuals of the final specification
*/
vecstable
veclmar
vecnorm
/*
	Examine the cointegrating relationships for reasonableness
*/
predict ce1, ce equation(_ce1)
label variable ce1 "CE for DC/VA"
predict ce2, ce equation(_ce2)
label variable ce2 "CE for MD/VA"
tsline ce1 ce2, yline(0) lpattern(solid longdash_dot) ytitle("Disequilibria")
graph export COINT_ce.eps, replace
generate diffdcva = dcwage - vawage
label variable diffdcva "DC/VA wage difference"
tsline ce1 diffdcva, yline(0) lpattern(solid longdash_dot) 
graph export COINT_cediff.eps, replace
ac ce1, name(ac1, replace)
ac ce2, name(ac2, replace)
graph combine ac1 ac2
graph export COINT_ceac.eps, replace
/*
	IRFs and forecasts
*/
estimates restore final
irf create wages, set(wages) step(20)
irf cgraph (wages dcwage dcwage oirf) (wages dcwage mdwage oirf) (wages dcwage vawage oirf) (wages mdwage dcwage oirf) (wages mdwage mdwage oirf) (wages mdwage vawage oirf) (wages vawage dcwage oirf) (wages vawage mdwage oirf) (wages vawage vawage oirf), legend(off) yscale(range(0))
graph export COINT_oirf.eps, replace
fcast compute O_, step(8)
fcast graph O_dcwage O_mdwage O_vawage
list date dcwage O_dcwage O_mdwage O_vawage
display %6.1f = 100 * ((O_dcwage[89]/dcwage[85]) - 1)
display %6.1f = 100 * ((O_dcwage[93]/dcwage[85]) - 1)
display %6.1f = 100 * ((O_mdwage[93]/mdwage[85]) - 1)
display %6.1f = 100 * ((O_vawage[93]/vawage[85]) - 1)
graph export COINT_Ofcast.eps, replace
generate newce1 = O_dcwage + 0.9315457 - 0.5788087*O_vawage
label variable newce1 "Projected CE"
label variable O_vawage "VA forecast"
local x = tq(2011:1)
two conn ce1 newce1 date if date>tq(2008:4), yline(0) xline(`x') lpattern(solid dash)
graph export COINT_newce.eps, replace
generate newce2 = O_mdwage - 11.48179 - 0.6666528*O_vawage
two conn ce2 newce2 date if date>tq(2008:4), yline(0) xline(`x') lpattern(solid dash) name(check2)
label variable O_dcwage "DC forecast"
label variable O_mdwage "MD forecast"
label variable O_vawage "VA forecast"
two conn dcwage O_dcwage mdwage O_mdwage vawage O_vawage date if date>tq(2008:4), lpattern(solid dash solid dash_dot solid longdash_dot) xline(`x') msymbol(smcircle smcircle smdiamond smdiamond smplus smplus)
graph export COINT_Ofcasto.eps, replace
fcast compute w_, step(32) dynamic(tq(2006:1))
fcast compute W_, step(16) dynamic(tq(2010:1))
label variable w_dcwage "End of 2005 forecast"
label variable W_dcwage "End of 2009 forecast"
label variable dcwage "DC actuals"
tsline dcwage w_dcwage W_dcwage if date>tq(2003:4), lpattern(solid dash longdash_dot)
graph export COINT_Mfcast.eps, replace
log close
