
clear

use ${ITSUS_DATA}/varexample, clear
quietly var inflation unrate fedfunds if date<=tq(2002q1), lags(1 2 3 4)

/*
	1-step-ahead conditional forecasts

	Inflation
*/
predict f_inflation
predict test1, equation(#1)
predict test2, equation(inflation)
summarize
label variable f_inflation "forecast"
compare f_inflation test1
compare f_inflation test2
drop test1 test2
compare inflation f_inflation if date>tq(2002q1)

predict r_inflation, equation(inflation) residuals

sum r_inflation if date<=tq(2002q1)
sum r_inflation if date>tq(2002q1)
predict s_inflation, equation(inflation) stdp
generate l_inflation = f_inflation - 2*s_inflation
generate u_inflation = f_inflation + 2*s_inflation

twoway 	(rarea u_inflation l_inflation date, fintensity(inten10))	///
	(line inflation f_inflation date, lpattern(solid dash))		///
	in -40/l, yline(0) 						///
	legend(/*order(2 3 1) label(1 "95% CI")*/ off) name(inflation, replace) /// 
	nodraw xscale(off) title("Inflation") fysize(100)


/*
	Unemployment rate
*/
predict f_unrate, equation(unrate)
label variable f_unrate "forecast"

predict r_unrate, equation(unrate) residuals
sum unrate if date>tq(2002q1) & date<tq(2008q1)
sum unrate if date>tq(2008q4)
compare unrate f_unrate if date>tq(2002q1)

sum r_unrate if date<=tq(2002q1)
sum r_unrate if date>tq(2002q1)
predict s_unrate, equation(unrate) stdp
generate l_unrate = f_unrate - 2*s_unrate
generate u_unrate = f_unrate + 2*s_unrate
label variable unrate "Unemp. rate"

twoway 	(rarea u_unrate l_unrate date, fintensity(inten10)) 		///
	(line unrate f_unrate date, lpattern(solid dash)) in -40/l, 	///
	legend(/* order(2 3 1) label(1 "95% CI")*/ off) name(unrate, replace)	///
	nodraw xscale(off) title("Unemployment Rate") fysize(100)

/*
	Fed funds
*/
predict f_fedfunds, equation(fedfunds)
label variable f_fedfunds "forecast"
predict r_fedfunds, equation(fedfunds) residuals
compare fedfunds f_fedfunds if date>tq(2002q1)
sum r_fedfunds if date<=tq(2002q1)
sum r_fedfunds if date>tq(2002q1)
predict s_fedfunds, equation(fedfunds) stdp
generate l_fedfunds = f_fedfunds - 2*s_fedfunds
generate u_fedfunds = f_fedfunds + 2*s_fedfunds
twoway 	(rarea u_fedfunds l_fedfunds date, fintensity(inten10))		///
	(line fedfunds f_fedfunds date, lpattern(solid dash)) in -40/l,	///
	yline(0) 							///
	legend(order(2 3 1) 	label(1 "95% CI")			///
				label(2 "Actual") 			///
				label(3 "Forecast")			///
		rows(1))						///
	name(fedfunds, replace) nodraw title("Federal Funds Rate") fysize(140)


graph combine inflation unrate fedfunds, cols(1) ysize(7) imargin(b=1 t=1)

graph export VAR_condfore.eps, replace

