set more off
capture log close
log using filter-1, replace
use ${ITSUS_DATA}/monthly, clear
keep date payroll unrate
generate Dpayroll = payroll - payroll[_n-1]
generate Dunrate = unrate - unrate[_n-1]
label variable Dpayroll "Change in nonfarm payroll (1000s)"
label variable Dunrate "Change in unemployment rate"
keep if year(dofm(date))>1949
keep if Dpayroll!=. & Dunrate!=.
tsset
scatter Dunrate Dpayroll, xline(0) yline(0) 
graph export FI_bls.eps, replace
correlate Dunrate Dpayroll
generate byte agree = sign(Dunrate)!=sign(Dpayroll)
tabulate agree
log close
