capture log close
capture erase trend.dta
capture erase cycle.dta
capture erase seasonal.dta
set more off
log using filter-3, replace

drop _all
set obs 60
generate int month = _n
label variable month Month
tsset month, monthly
/*
	Trend
*/
generate trend = _n
label variable trend Trend
set seed 53
generate rawtrend = trend + 4*rnormal()
replace rawtrend = 20 in 46		/* Outlier */
label variable rawtrend "Raw data"
generate residual = rawtrend - trend
label variable residual Residual
format trend rawtrend residual %6.2f
sort month
save trend
tsline trend rawtrend
graph export FI_trend.eps, replace
foreach smoother in h 3 3h h3 9 {
	tssmooth nl S`smoother' = rawtrend, smoother(`smoother')
}
tsline rawtrend S3 Sh, lpattern(solid dash dash_dot)
graph export FI_T3vsh.eps, replace
tsline rawtrend S3 Sh in 30/50, lpattern(solid dash dash_dot)
graph export FI_T3vshsub.eps, replace
tsline rawtrend S3 S3h Sh3 in 30/50, lpattern(solid dash dash_dot longdash_dot)
graph export FI_T3vs3hvsh3.eps, replace
tsline rawtrend S3 S9 in 30/50, lpattern(solid dash dash_dot)
graph export FI_T3vs9.eps, replace
/*
	Cycle
*/
drop _all
set obs 60
generate int month = _n
label variable month Month
tsset month, monthly
set seed 23
generate cycle = 2*sin(8*_pi*_n/_N)
label variable cycle Cycle
generate rawcycle = cycle + rnormal()
label variable rawcycle "Raw data"
generate residual = rawcycle - cycle
format cycle rawcycle residual %6.2f
sort month
save cycle
tsline cycle rawcycle
graph export FI_cycle.eps, replace
foreach smoother in 3 3h 9 {
	tssmooth nl S`smoother' = rawcycle, smoother(`smoother')
}
tsline rawcycle S3 S3h S9, lpattern(solid dash dash_dot longdash_dot)
graph export FI_CS.eps, replace
tsline rawcycle S3 S3h S9 in 30/50, lpattern(solid dash dash_dot longdash_dot)
graph export FI_CSsub.eps, replace
tsline S3 S3h in 30/50, lpattern(solid dash)
graph export FI_Cflat.eps, replace
tsline cycle rawcycle S3 in 55/l, lpattern(solid dash dash_dot)
graph export FI_Cend.eps, replace
tssmooth nl S3e = rawcycle, smoother(3e)
tsline cycle rawcycle S3 S3e in 55/l, lpattern(solid dash dash_dot longdash_dot)
graph export FI_Cendfix.eps, replace
/*
	TED spread
*/
use ${ITSUS_DATA}/daily, clear
generate ted = 100*(libor3m - otr3m)	/* convert rates to basis points */
format ted %6.0f
label variable ted "TED spread (in b.p.)"
keep if !missing(ted)
tsset
summarize ted
list if date==mdy(10,10,2008)
tsline ted
graph export FI_ted.eps, replace
*tssmooth nl smooth = ted, smoother(3rssh)
generate n = _n
tsset n, generic
tssmooth nl smooth = ted, smoother(3rssh)
label variable smooth "Smooth, 3RSSH"
save ted, replace
tsline ted smooth if date>mdy(7,31,2008) & date<mdy(1,1,2009), lpattern(solid dash)
graph export FI_ted08.eps, replace
generate residual = ted - smooth
label variable residual "Residual, 3RSSH"
tsline residual if date>mdy(7,31,2008) & date<mdy(1,1,2009), yline(0)
graph export FI_tedres08.eps, replace
tssmooth nl S3h = ted, smoother(3h)
generate R3h = S3h - ted 
label variable R3h "Residual, 3H"
tsline residual R3h if date>mdy(7,31,2008) & date<mdy(1,1,2009), yline(0) lpattern(solid dash)
graph export FI_tedrescmp.eps, replace
log close
