set more off
capture log close
log using filter-4, replace
/*
	nl and ma
*/
use ${ITSUS_DATA}/trend, clear
tssmooth nl NLh = rawtrend, smoother(h)
tssmooth ma MAh = rawtrend, weights(1 < 2 > 1)
describe NLh MAh
compare NLh MAh
format NLh MAh %6.2f
list rawtrend NLh MAh in f/3
/* tssmooth endpoint method */
display %6.2f = (2*rawtrend[1] + 1*rawtrend[2])/3
list rawtrend NLh MAh in -3/l
/* tssmooth endpoint method */
display %6.2f = (2*rawtrend[60] + 1*rawtrend[59])/3
tssmooth nl NLhe = rawtrend, smoother(he)
format NLhe %6.2f
list rawtrend NLh NLhe NLh in f/3
/* smooth E endpoint method */
display %6.2f = 3*NLh[2] - 2*NLh[3]
/*
	exponential and dexponential
*/
use cycle, clear
tssmooth nl S3rssh = rawcycle, smoother(3rssh)
tsset month, monthly
count
summarize rawcycle in f/30
tssmooth exponential default = rawcycle
label variable default "alpha = 0.8"
list rawcycle cycle in f
tssmooth exponential ewma = rawcycle, parm(0.3) s0(0.26)
label variable ewma "alpha = 0.3"
tsline cycle S3rssh default ewma, lpattern(solid dash dash_dot longdash_dot) 
graph export FI_ewma.eps, replace
use ted, clear
generate int newdate = _n
tsset newdate, daily
tssmooth dexponential dewma = ted
tsline ted smooth dewma if date>mdy(8,31,2008) & date<mdy(1,1,2009), lpattern(solid dash dash_dot)
graph export FI_dewma.eps, replace
/*
	Holt-Winters
*/
use ${ITSUS_DATA}/quarterly, clear
tssmooth hwinters hw = gdp, parms(0.7 0.5) samp0(10)
label variable hw "HW(0.7 0.5) = gdp"
tssmooth exponential ewma = gdp
label variable ewma "EWMA(0.9998) = gdp"
tsline gdp hw ewma, lpattern(solid dash dash_dot)
graph export FI_hw.eps, replace
tsline gdp hw ewma if year(dofq(date))>2000, lpattern(solid dash dash_dot)
graph export FI_hw2000.eps, replace
generate Rhw = hw - gdp
generate Rewma = ewma - gdp
tsline Rhw Rewma if year(dofq(date))>2000, yline(0) lpattern(solid dash)
graph export FI_Rhw.eps, replace
generate lgdp = log(gdp)
tssmooth hwinters lhw = lgdp, samp0(10)
label variable hw "HW(1.0 0.107) = lgdp"
tssmooth exponential lewma = lgdp
label variable ewma "EWMA(0.9998) = lgdp"
tsline lgdp lhw lewma if year(dofq(date))>2000, lpattern(solid dash dash_dot)
graph export FI_lhw.eps, replace
generate Rlhw = lhw - lgdp
generate Rlewma = lewma - lgdp
tsline Rlhw Rlewma if year(dofq(date))>2000, yline(0) lpattern(solid dash)
graph export FI_Rlhw.eps, replace
log close
