set more off
capture log close
/*
	Alternative simple forecasts of the unemploymnent rate

	EWMA
*/
log using forecast-1, replace
use ${ITSUS_DATA}/monthly, clear
keep date unrate
keep if !missing(unrate)
tsset
tssmooth exponential ewma = unrate, parms(0.9)
label variable ewma "EWMA(0.9)"
list date if date==tm(2009m4) | date==tm(2009m12)
generate apr = ewma[736] if _n>736
label variable apr "April 2009 forecast"
generate dec = ewma[744] if _n>744
label variable dec "December 2009 forecast"
two (conn unrate date, msymbol(o)) (line apr dec date, lpattern(solid dash)) if date>tm(2005m12), ytitle(Percent) name(aprmay, replace)
graph export FO_aprmay.eps, replace
generate aprres = apr - unrate
label variable aprres "April 2009 forecast"
generate decres = dec - unrate
label variable decres "December 2009 forecast"
two line aprres decres date if aprres!=. | decres!=., lpattern(solid dash) yline(0) ytitle(Percent) name(aprmayres, replace)
graph export FO_aprmayres.eps, replace
generate oneewma = ewma - unrate
label variable oneewma "EWMA(0.9)"
generate onenoch = unrate[_n-1] - unrate
label variable onenoch "No change"
generate sqewma = oneewma^2
label variable sqewma "EWMA(0.9)"
generate sqnoch = onenoch^2
label variable sqnoch "No change"
/*
	DEWMA
*/
tssmooth dexponential dewma = unrate if date<tm(2009m5), parms(0.5) forecast(35)
generate dapr = dewma if date>tm(2009m4)
label variable dapr "April 2009 forecast"
drop dewma
tssmooth dexponential dewma = unrate if date<tm(2010m1), parms(0.5) forecast(27)
generate ddec = dewma if date>tm(2009m12)
label variable ddec "December 2009 forecast"
two (conn unrate date, msymbol(o)) (line dapr ddec date, lpattern(solid dash)) if date>tm(2005m12), ytitle(Percent) name(daprmay, replace)
graph export FO_daprmay.eps, replace
generate daprres = dapr - unrate
label variable daprres "April 2009 forecast"
generate ddecres = ddec - unrate
label variable ddecres "December 2009 forecast"
two line daprres ddecres date if daprres!=. | ddecres!=., lpattern(solid dash) yline(0) ytitle(Percent) name(daprmayres, replace)
graph export FO_daprmayres.eps, replace
label variable aprres "EWMA(Apr)"
label variable daprres "DEWMA(Apr)"
label variable decres "EWMA(Dec)"
label variable ddecres "DEWMA(Dec)"
two line aprres daprres decres ddecres date if aprres!=., lpattern(solid dash_dot dash longdash_dot) yline(0) ytitle(Percentage points) name(edres, replace)
graph export FO_edres.eps, replace
drop dewma
tssmooth dexponential dewma = unrate, parms(0.5)
label variable dewma "DEWMA(0.5)"
generate onedewma = dewma - unrate
label variable onedewma "DEWMA(0.5)"
generate sqdewma = onedewma^2
label variable sqdewma "DEWMA(0.5)"
two line one* date if date>tm(2005m12), lpattern(solid dash dash_dot) yline(0) ytitle(Percent) name(oneres, replace)
graph export FO_oneres.eps, replace
two line sq* date if date>tm(2005m12), lpattern(solid dash dash_dot) ytitle(Squared errors) name(sqres, replace)
graph export FO_sqres.eps, replace
generate int etenth = 10*oneewma
generate int dtenth = 10*onedewma
generate int ntenth = 10*onenoch
tab1 etenth dtenth ntenth
label variable etenth "EWMA errors"
label variable dtenth "DEWMA errors"
label variable ntenth "No change errors"
replace etenth = max(min(etenth,10),-10)
replace dtenth = max(min(dtenth,10),-10)
replace ntenth = max(min(ntenth,10),-10)
hist etenth, percent width(1) blcolor(black) bfcolor(gray) name(etenth, replace)
hist dtenth, percent width(1) blcolor(black) bfcolor(gray) name(dtenth, replace)
hist ntenth, percent width(1) blcolor(black) bfcolor(gray) name(ntenth, replace)
graph combine ntenth etenth dtenth, name(tenths, replace)
graph export FO_tenths.eps, replace
count
local N = `r(N)'
count if sqewma < 0.04
display %6.0f = 100*`r(N)'/`N'
count if sqdewma < 0.04
display %6.0f = 100*`r(N)'/`N'
count if sqnoch < 0.04
display %6.0f = 100*`r(N)'/`N'
quietly summarize sqewma
display "RMSE(EWMA) = " %6.2f = sqrt(`r(mean)')
quietly summarize sqdewma
display "RMSE(DEWMA) = " %6.2f = sqrt(`r(mean)')
quietly summarize sqnoch
display "RMSE(No change) = " %6.2f = sqrt(`r(mean)')
/*
	HW
*/
tssmooth hwinters hw = unrate if date<tm(2009m5), parms(0.8 0.3) forecast(35)
generate hapr = hw if date>tm(2009m4)
label variable hapr "HW(April)"
drop hw
tssmooth hwinters hw = unrate if date<tm(2010m1), parms(0.8 0.3) forecast(27)
generate hdec = hw if date>tm(2009m12)
label variable hdec "HW(December)"
label variable dapr "DEWMA(April)"
label variable ddec "DEWMA(December)"
two line dapr ddec hapr hdec date if dapr!=., lpattern(solid solid dash dash) ytitle(Percent) name(dewmavshw, replace)
graph export FO_dewmavshw.eps, replace
/*
	Clean up
*/
log close
