set more off
capture log close
/*
	Gather together the RMSE and histogram code from forecast-1.do
*/
log using forecast-1a, replace
use ${ITSUS_DATA}/monthly, clear
keep date unrate
keep if !missing(unrate)
tsset
generate ewma = . 
generate dewma = .
/*
	EWMA one-step-ahead forecast
*/
drop ewma
tssmooth exponential ewma = unrate, parms(0.9)
generate oneewma = ewma - unrate
/*
	DEWMA one-step-ahead forecast
*/
drop dewma
tssmooth dexponential dewma = unrate, parms(0.5)
generate onedewma = dewma - unrate
/*
	No change one-step-ahead forecast
*/
generate onenoch = unrate[_n-1] - unrate
generate sqnoch = onenoch^2
summarize sqnoch
display "RMSE(No change) = " %6.2f = sqrt(`r(mean)')
display "`r(mean)'"
/*
	Histograms of error distributions
*/
generate int etenth = 10*oneewma
list etenth oneewma in f/5
generate int dtenth = 10*onedewma
generate int ntenth = 10*onenoch
summarize etenth dtenth ntenth
count
local N = `r(N)'
count if abs(etenth) < 2
display %6.0f = 100*`r(N)'/`N'
count if abs(dtenth) < 2
display %6.0f = 100*`r(N)'/`N'
count if abs(ntenth) < 2
display %6.0f = 100*`r(N)'/`N'
tab1 ntenth etenth dtenth
label variable ntenth "No change errors"
label variable etenth "EWMA errors"
label variable dtenth "DEWMA errors"
replace ntenth = max(min(ntenth,10),-10)
replace etenth = max(min(etenth,10),-10)
replace dtenth = max(min(dtenth,10),-10)
hist ntenth, percent width(1) blcolor(black) bfcolor(gray) name(ntenth, replace)
hist etenth, percent width(1) blcolor(black) bfcolor(gray) name(etenth, replace)
hist dtenth, percent width(1) blcolor(black) bfcolor(gray) name(dtenth, replace)
graph combine ntenth etenth dtenth, name(tenths, replace)
graph export FO_tenths.eps, replace
/*
	Clean up
*/
log close
