set more off
capture log close
log using forecast-2b, replace
/*
	Repeat forecast-2a, except for the tsset error
*/
use ${ITSUS_DATA}/currcomp, clear
tsline currcomp, ytitle($ billions)
graph export FO_cc.eps, replace
tsline currcomp if year>1997, ytitle($ billions)
graph export FO_cc98.eps, replace
generate lcc = log(currcomp)
label variable lcc "Log(currency component of M1)"
generate wdate = wofd(date)
label variable wdate "Date"
/*
	Real start of forecast-2b
*/
list if wdate==wdate[_n-1]
list in 260/261
count if year==1979
drop if wdate==wdate[_n-1]
tsset wdate, weekly
tssmooth shwinters shw = lcc, forecast(104)
label variable shw "Seas. HW forecast"
tsline lcc shw if year(date)>2006, lpattern(solid dash)
graph export FO_ccshw.eps, replace
tssmooth shwinters backtest = lcc if wdate<=tw(2000w17), forecast(500)
label variable backtest "Back test"
local xl = tw(2000w17)
tsline lcc backtest if wdate>=tw(1998w1) & wdate<=tw(2009w52), lpattern(solid dash) xline(`xl')
graph export FO_backtest.eps, replace
log close
