set more off
clear
capture log close
log using garch-1, replace
/*
	TED spread
*/
use ${ITSUS_DATA}/daily, clear
generate ted = 100*(libor3m - otr3m)	/* convert rates to basis points */
label variable ted "TED spread"
keep if !missing(ted)
tsset
tsline ted, name(ted, replace)
graph export GARCH_ted.eps, replace
generate year = year(date)
summarize D.ted, detail
graph box D.ted, ytitle("One-day change in basis points")
graph export GARCH_boxdted.eps, replace
generate dted = D.ted
label variable dted "Change in TED spread"
egen sddted = sd(dted), by(year)
label variable sddted "Volatility of TED spread"
two connected sddted year, name(sddted, replace)
graph export GARCH_sddted.eps, replace
/*
	U.S. real GDP	
*/
use ${ITSUS_DATA}/quarterly, clear
tsset
generate lrgdp = log(gdp2005)
label variable lrgdp "Log of real GDP"
generate growth = 400*(lrgdp - L.lrgdp)
label variable growth "Growth rate of real GDP"
format growth %6.1f
generate year = year(dofq(date))
generate int decade = 10 * int(year/10)
generate int quint = cond(year-decade<5,decade,decade+5)
label variable quint "Half-decade"
egen sdgrowth = sd(growth), by(year)
label variable sdgrowth "s.d. of real GDP growth"
two connected sdgrowth year, xlabel(1950 1960 1970 1980 1990 2000 2010)
graph export GARCH_sdgrowth.eps, replace
egen qsdgrowth = sd(growth), by(quint)
label variable qsdgrowth "5-year s.d. of real GDP growth"
two connected qsdgrowth quint if year>1949, xlabel(1950 1960 1970 1980 1990 2000 2010)
graph export GARCH_qsdgrowth.eps, replace
log close
