set more off
clear
capture log close
log using garch-2, replace
/*
	U.S. real GDP	
*/
use ${ITSUS_DATA}/quarterly, clear
tsset
generate lrgdp = log(gdp2005)
label variable lrgdp "Log of real GDP"
generate growth = 400*(lrgdp - L.lrgdp)
label variable growth "Growth rate of real GDP"
format growth %6.1f
arima growth, ar(1) nolog
regress L(0/1).growth
display = _b[_cons]/(1 - _b[L1.growth])
estat archlm, lags(1)
estat archlm, lags(1 2 3 4)
arch growth, ar(1) arch(1) nolog
arch growth, ar(1) arch(1 2) nolog
arch growth, ar(1) arch(1 2 3) nolog
arima growth, ma(1 2) nolog
arch growth, ma(1 2) arch(1) nolog
arch growth, ma(1 2) arch(1 2) nolog
arch growth, ma(1 2) arch(1 2 3) nolog
arch growth, ar(1) arch(1 2) nolog
predict variance, variance
generate ydate = dofq(date)
label variable ydate Date
format ydate %dCCYY
tsline variance
graph export GARCH_grvar.eps, replace
log close
