set more off
clear
capture log close
log using garch-3, replace
/*
	U.S. real GDP	
*/
use ${ITSUS_DATA}/monthly, clear
tsset
drop if date<tm(1960m1)
generate lcpi = log(cpi)
generate anncpi = 100*S12.lcpi
label variable anncpi "Annual CPI inflation"
generate inflation = 1200*D.lcpi
label variable inflation "Monthly CPI inflation"
two (line inflation date) (connected anncpi date, msymbol(+) msize(small)), yline(0)
graph export GARCH_inflate.eps, replace
regress L(0/8)D.lcpi
estat archlm, lags(1,2,3,4)
arima inflation, arima(2,0,1) nolog
arch inflation, arima(2,0,1) arch(1 2 3) nolog
predict avar, variance
label variable avar "ARCH conditional variance"
arch inflation, arima(2,0,1) arch(1) garch(1) nolog
predict gvar, variance
label variable gvar "GARCH conditional variance"
arch inflation, arima(2,0,1) arch(1 2) garch(1) nolog
arch inflation, arima(2,0,1) arch(1) garch(1 2) nolog
correlate gvar avar
compare gvar avar
two (scatter gvar avar) (line avar avar), xscale(log) yscale(log) xlabel(10 25 50 100 200) ylabel(10 25 50 100 200) legend(off) ytitle("GARCH conditional variance") xsize(4) ysize(4) name(archgarch, replace)
graph export GARCH_g_vs_a.eps, replace
tsline gvar
graph export GARCH_garchvar.eps, replace
arch inflation, arima(2,0,1) earch(1 2 3) nolog
test [ARCH]:L.earch L2.earch L3.earch
arch inflation, arima(2,0,1) earch(1) egarch(1) nolog
log close
