clear
set more off
capture log close
log using gdp-1, replace
/*
	Preliminary data summary of real GDP
*/
use ${ITSUS_DATA}/quarterly, clear
tsset 
generate lrgdp = log(gdp2005)
label variable lrgdp "Log of real GDP"
tsline lrgdp
graph export GDP_lrgdp.eps, replace
regress lrgdp date
display 400 * _b[date]
tssmooth hwinters hw = lrgdp, forecast(12)
label variable hw "HW smooth"
generate Rhw = hw - lrgdp
label variable Rhw "HW residual"
predict trend
label variable trend "Trend growth, 1947:1-2012:1"
predict resid, residual
replace resid = - resid
label variable resid "Trend residual"
tsline trend hw if lrgdp!=., lpattern(solid dash) title(Trend line and HW smooth for real GDP)
graph export GDP_trend.eps, replace
tsline resid Rhw, yline(0) lpattern(solid dash) title(Residuals)
graph export GDP_resid.eps, replace
local projdate = tq(2012q1) + 0.5
two (line trend hw date if date>tq(2004q4), lpattern(solid dash)) (conn lrgdp date if date>tq(2004q4), msymbol(oh)), xline(`projdate') ytitle(Log or real GDP) title("Forecast of GDP, 2012:2-2015:1")
graph export GDP_simplefcast.eps, replace
generate ahead1 = _b[date] + L.lrgdp
summarize resid if date==tq(2012q1)
local adjust = `r(mean)'
replace ahead1 = trend - `adjust' if missing(ahead1)
label variable ahead1 "Trend growth"
two (line ahead1 hw date if date>tq(2004q4), lpattern(solid dash)) (conn lrgdp date if date>tq(2004q4), msymbol(oh)), xline(`projdate') ytitle(Log of real GDP) title(One-step-ahead forecast)
graph export GDP_ahead.eps, replace
log close
