clear
set more off
capture log close
log using gdp-2, replace
/*
	Identifying known processes
*/
clear
set obs 120
generate int t = _n
tsset t
set seed 95
/*
	White noise
*/
generate epsilon = rnormal()
ac epsilon, name(aceps, replace) lags(20)
pac epsilon, name(paceps, replace) lags(20)
graph combine aceps paceps
graph export GDP_epsilon.eps, replace
/*
	Pure AR processes
*/
generate ar1_9 = epsilon in f
replace ar1_9 = 0.9*L.ar1_9 + epsilon in 2/l
ac ar1_9, name(ac_ar1_9, replace) lags(20)
pac ar1_9, name(pac_ar1_9, replace) lags(20)
graph combine ac_ar1_9 pac_ar1_9
graph export GDP_ar1_9.eps, replace
generate ar1_7 = epsilon in f
replace ar1_7 = 0.7*L.ar1_7 + epsilon in 2/l
ac ar1_7, name(ac_ar1_7, replace) lags(20)
pac ar1_7, name(pac_ar1_7, replace) lags(20)
graph combine ac_ar1_7 pac_ar1_7
graph export GDP_ar1_7.eps, replace
generate ar2 = epsilon
replace ar2 = 0.9*L.ar2 - 0.1*L2.ar2 + epsilon in 3/l
ac ar2, name(ac_ar2, replace) lags(20)
pac ar2, name(pac_ar2, replace) lags(20)
graph combine ac_ar2 pac_ar2
graph export GDP_ar2.eps, replace
/*
	Pure MA processes
*/
generate ma1 = epsilon - 0.9*L.epsilon
ac ma1, name(ac_ma1, replace) lags(20)
pac ma1, name(pac_ma1, replace) lags(20) generate(pacma1)
graph combine ac_ma1 pac_ma1
graph export GDP_ma1.eps, replace
generate ma2 = epsilon - 0.9*L.epsilon + 0.1*L2.epsilon
ac ma2, name(ac_ma2, replace) lags(20)
pac ma2, name(pac_ma2, replace) lags(20)
graph combine ac_ma2 pac_ma2
graph export GDP_ma2.eps, replace
/*
	ARMA processes
*/
generate arma11 = epsilon in f
replace arma11 = 0.7*L.arma11 + epsilon - 0.5*L.epsilon in 2/l
ac arma11, name(ac_arma11, replace) lags(20)
pac arma11, name(pac_arma11, replace) lags(20)
graph combine ac_arma11 pac_arma11
graph export GDP_arma11.eps, replace
log close
