clear
set more off
capture log close
log using gdp-3, replace
/*
	Fit an ARIMA model to U.S. real GDP	
*/
use ${ITSUS_DATA}/quarterly, clear
tsset 
generate lrgdp = log(gdp2005)
label variable lrgdp "Log of real GDP"
/*
	Checking for stationarity
*/
ac lrgdp, name(aclevel, replace)
graph export GDP_aclevel.eps, replace
/*
	Differencing to achieve stationarity and
	identification of the order of the model
*/
generate growth = lrgdp - L.lrgdp
label variable growth "Growth rate of real GDP"
ac growth, name(ac, replace) lag(20)
graph export GDP_acgrowth.eps, replace
pac growth, name(pac, replace) lag(20)
graph combine ac pac
graph export GDP_ident.eps, replace
/*
	Estimating alternative ARIMA models
*/
arima growth, arima(1,0,2)
estat ic
arima, coeflegend
display 400 * _b[growth:_cons]
local psi11 = _b[ARMA:L.ar] - _b[ARMA:L.ma]
local psi12 = (_b[ARMA:L.ar])*(`psi11') - _b[ARMA:L2.ma]
local psi13 = (_b[ARMA:L.ar])*(`psi12')
local psi14 = (_b[ARMA:L.ar])*(`psi13')
arima growth, arima(1,0,1) nolog
estat ic
display 400 * _b[growth:_cons]
local psi21 = _b[ARMA:L.ar] - _b[ARMA:L.ma]
local psi22 = (_b[ARMA:L.ar])*(`psi21')
local psi23 = (_b[ARMA:L.ar])*(`psi22')
local psi24 = (_b[ARMA:L.ar])*(`psi23')
display in green _n "Psi weights:" _n _n "Model" _skip(7) "1" _skip(9) "2" _n /*
*/ _dup(26) _char(208) _n /*
*/ in green "psi1" _skip(6) in yellow %6.3f = `psi11' _skip(4) %6.3f `psi21' _n /*
*/ in green "psi2" _skip(6) in yellow %6.3f = `psi12' _skip(4) %6.3f `psi22' _n /*
*/ in green "psi3" _skip(6) in yellow %6.3f = `psi13' _skip(4) %6.3f `psi23' _n /*
*/ in green "psi4" _skip(6) in yellow %6.3f = `psi14' _skip(4) %6.3f `psi24' _n
arima growth, ar(1) nolog
local psi11 = _b[ARMA:L.ar]
local psi12 = _b[ARMA:L.ar] * `psi11'
local psi13 = _b[ARMA:L.ar] * `psi12'
local psi14 = _b[ARMA:L.ar] * `psi13'
arima growth, ma(1 2) nolog
local psi21 = _b[ARMA:L.ma]
local psi22 = _b[ARMA:L2.ma]
local psi23 = 0
local psi24 = 0
display in green _n "Psi weights:" _n _n "Model" _skip(7) "1" _skip(9) "2" _n /*
*/ _dup(26) _char(208) _n /*
*/ in green "psi1" _skip(6) in yellow %6.3f = `psi11' _skip(4) %6.3f `psi21' _n /*
*/ in green "psi2" _skip(6) in yellow %6.3f = `psi12' _skip(4) %6.3f `psi22' _n /*
*/ in green "psi3" _skip(6) in yellow %6.3f = `psi13' _skip(4) %6.3f `psi23' _n /*
*/ in green "psi4" _skip(6) in yellow %6.3f = `psi14' _skip(4) %6.3f `psi24' _n
arima growth, ar(1 2) nolog
arima growth, ma(1 2 3) nolog
arima growth, ma(1 2) nolog
predict resid, residual
wntestq resid
wntestb resid
graph export GDP_cumperiod.eps, replace
arima growth, ar(1) nolog
predict arxb
label variable arxb "Default (arxb)"
predict arst, structural
label variable arst "Structural (arst)"
predict ardy, dynamic(tq(2008q1))
label variable ardy "Dynamic (ardy)"
predict art0, t0(tq(2008q1))
label variable art0 "t0=2008Q1 (art0)"
foreach x in xb st dy t0 {
	replace ar`x' = 400 * ar`x'
}
generate agrowth = 400*growth
format agrowth ar* %6.1f
list date agrowth ar* in f/5
list date agrowth ar* if date>tq(2006q4)
local xl = tq(2008q1)
tsline arxb arst ardy art0 if date>tq(2006q4), lpattern(dash solid longdash_dot dash_dot) xline(`xl') 
graph export GDP_forecast.eps, replace
arima growth, ma(1 2) nolog
predict maxb
predict mast, structural
predict mady, dynamic(tq(2008q1))
predict mat0, t0(tq(2008q1))
foreach x in xb st dy t0 {
	replace ma`x' = 400 * ma`x'
}
format ma* %6.1f
list date agrowth ma* in f/5
list date agrowth ma* if date>tq(2006q4)
log close
