set more off
clear
capture log close
log using gdp-4, replace
/*
	Compare forecasts of GDP
*/
use ${ITSUS_DATA}/quarterly, clear
tsset
generate lrgdp = log(gdp2005)
label variable lrgdp "Log of real GDP"
generate growth = 400*D.lrgdp
label variable growth "Growth rate of real GDP"
/*
	Linear growth trend model
*/
regress lrgdp date if date<tq(2002q2)
predict trend
predict tres, residual
label variable trend "Trend"
label variable tres "Trend"
generate tg = 400*_b[date]
generate tgres = tg - growth
label variable tg "Trend growth"
label variable tgres "Trend growth"
/*
	Holt-Winters model
*/
tssmooth hwinters hw = lrgdp if date<tq(2002q2), forecast(40)
generate hwg = 400*D.hw
generate hwres = hw - lrgdp
generate hwgres = hwg - growth
label variable hw "HW smooth"
label variable hwg "HW smooth"
label variable hwres "HW smooth"
label variable hwg "HW smooth"
/*
	AR(1) model
*/
arima growth if date<tq(2002q2), ar(1) nolog
predict ardg, dynamic(tq(2002q2))
predict ardgres, residual
replace ardgres = -ardgres
label variable ardg "AR(1)"
label variable ardgres "AR(1)"
/*
	MA(2) model
*/
arima growth if date<tq(2002q2), ma(1 2) nolog
predict madg, dynamic(tq(2002q2))
predict madgres, residual
replace madgres = -madgres
label variable madg "MA(2)"
label variable madgres "MA(2)"
/*
	Levels
*/
arima lrgdp date, arima(1,0,2)
generate byte period = date>tq(2002q1)
label define period 0 "In sample" 1 "Out of sample"
label values period period
table period, contents(mean growth mean ardg mean madg mean hwg mean tg) format(%6.1f) row
table period, contents(mean ardgres mean madgres mean hwgres mean tgres) format(%6.1f) row
table period, contents(sd ardgres sd madgres sd hwgres sd tgres) format(%6.1f) row
/*
	Limit the forecast to the first four out-of-sample quarters
*/
table date if date>tq(2002q1) & date<tq(2003q2), contents(mean growth mean ardg mean madg mean hwg mean tg) format(%6.1f) row
table date if date>tq(2002q1) & date<tq(2003q2), contents(mean ardgres mean madgres mean hwgres mean tgres) format(%6.1f) row
local projdate = tq(2002q1) + 0.5
two (connected growth date) (line ardg madg hwg tg date, lpattern(solid dash longdash_dot longdash)) if date>tq(2001q1) & date<tq(2003q2), xline(`projdate') yline(0) name(period4, replace)
graph export GDP_period4.eps, replace
/*
	ARMAX model of a trend
*/
tempfile temp
save `temp'
use ${ITSUS_DATA}/monthly, clear
generate paych = 400 * (payroll - payroll[_n-3])/payroll[_n-3]
generate year = year(dofm(date))
generate quarter = quarter(dofm(date))
generate qdate = yq(year,quarter)
format qdate %tqCCYY:q
keep if !mod(month(dofm(date)),3)
keep qdate paych year
rename qdate date 
label variable date Date
tsset date, quarterly
merge 1:1 date using `temp'
arima growth paych if date<tq(2002q2), ar(1) nolog
predict armax, dynamic(tq(2002q2))
label variable armax "ARMAX"
generate armaxres = armax - growth
label variable armaxres "ARMAX"
table date if date>tq(2002q1) & date<tq(2003q2), contents(mean growth mean ardg mean armax mean tg) format(%6.1f) row
table date if date>tq(2002q1) & date<tq(2003q2), contents(mean ardgres mean armax mean tgres) format(%6.1f) row
table year if date>tq(2002q1) & date<tq(2003q2), contents(sd ardgres sd armaxres sd tgres) format(%6.1f)
table period, contents(sd ardgres sd armaxres) format(%6.1f)
two (connected growth date) (line ardg tg armax date, lpattern(solid longdash dash_dot)) if date>tq(2001q1) & date<tq(2003q2), xline(`projdate') yline(0) name(armax, replace)
graph export GDP_armax.eps, replace
log close
