set more off
capture log close
log using juststata-3, replace
/*
	World Bank data

	co2, co2gdp, co2pcap
	doctors, nurses, under5mort, malaria
	primaryed, girlstoboys
	pop, popgrowth, gdp, gnpcap, urbgtmil
	kggdp, kgpcap
	lowland, lowpop
	protected, roads, sanitation
*/
pwd
display "${ITSUS_DATA}"
display "${ITSUS_DATA}"
clear
use ${ITSUS_DATA}/wbdata
describe
tabulate country
summarize year
count if year==2011
list code in f
list country in f
tabulate code if index(country,"Canada")
summarize
describe degrees
count if degrees!=""
tabulate degrees
generate degmin = real(substr(degrees,1,index(degrees,"/")-1))
generate degmax = real(substr(degrees,index(degrees,"/")+1,.))
list deg* in 22
describe g*
table year, contents(count gnppcap)
summarize gnppcap if year==2007
summarize gnppcap if year==2007, detail
histogram gnppcap if year==2007, percent color(gray) blcolor(black)
graph export JUSTSTATA_hist.eps, replace
histogram gnppcap [fw=int(pop + 0.5)], percent color(gray) blcolor(black)
graph export JUSTSTATA_wthist.eps, replace
summarize girlstoboys if year==2007
histogram girlstoboys if year==2007, percent color(gray) blcolor(black)
graph export JUSTSTATA_girls.eps, replace
histogram girlstoboys [fw=int(pop + 0.5)], percent color(gray) blcolor(black)
graph export JUSTSTATA_wtgirls.eps, replace
scatter gnppcap girlstoboys if year==2007
graph export JUSTSTATA_gg.eps, replace
scatter gnppcap girlstoboys if year==2007, yscale(log)
graph export JUSTSTATA_gglog.eps, replace
scatter gnppcap girlstoboys if year==2007, yscale(log) xlabel(60 70 80 90 100 110) ylabel(100 1000 10000 100000)
graph export JUSTSTATA_ggclean.eps, replace
scatter gnppcap girlstoboys if year==2007 [fw=int(pop + 0.5)], yscale(log) xlabel(60 70 80 90 100 110) ylabel(100 1000 10000 100000)
graph export JUSTSTATA_ggpop.eps, replace
keep if code=="USA":code
two line gdp year
graph export JUSTSTATA_gdp.eps, replace
two connected co2 year
graph export JUSTSTATA_co2.eps, replace
two (connected co2 year) (line gdp year)
graph export JUSTSTATA_overlay.eps, replace
two (connected co2 year) (line gdp year, yaxis(2))
graph export JUSTSTATA_yaxis.eps, replace
two connected kgpcap year, mlabel(year)
graph export JUSTSTATA_marker.eps, replace
tsset year, yearly
tsline gdp
graph export JUSTSTATA_tsline.eps, replace
log close

exit
*keep if code=="LIC":code | code=="HIC":code
keep if code=="CAN":code | code=="CHN":code | code=="ITA":code | code=="JPN":code | code=="USA":code | code=="VEN":code
