set more off
capture log close
log using juststata-4, replace
/*
	Statistics

	Basics
*/
use ${ITSUS_DATA}/wbdata, clear
count
count if country=="Iceland"A
generate int inccat = recode(gnppcap, 0, 100, 1000, 10000, 25000, 50000, 75000)
format inccat %6.0fc
tabulate inccat
generate int girlcat = 10 * int(girlstoboys/10)
tabulate girlcat inccat
tabulate girlcat inccat, nofreq cell chi2
summarize girlstoboys if year==2007
summarize girlstoboys if year==2007, detail
describe co2pcap
correlate gnppcap girlstoboys co2pcap
table year, contents(count gnppcap mean gnppcap max co2pcap sd girlstoboys) row format(%6.1f)
/*
	Estimation
*/
keep if year==2008
regress co2pcap gnppcap
regress co2pcap gnppcap kgpcap
drop if co2pcap==. | gnppcap==. | kgpcap==.
nl (co2pcap = {b0} + {b1}*gnppcap + {b2}*kgpcap)
nl (co2pcap = {b0} + {b1}*gnppcap + {b1}*kgpcap)
constraint define 1 gnppcap = kgpcap
constraint list
quietly regress co2pcap gnppcap kgpcap
predict fit
two (line fit kgpcap, sort) (scatter co2pcap kgpcap, mlabel(code))
graph export JUSTSTATA_isl.eps, replace
predict resid, residual
two scatter resid kgpcap, yline(0)
graph export JUSTSTATA_islres.eps, replace
regress
test kgpcap
test gnppcap, accumulate
testparm kgpcap gnppcap
test kgpcap = 0.00165
test kgpcap = gnppcap
display = _b[kgpcap]
nlcom _b[kgpcap]*_b[gnppcap]
estat summarize
estat ic
estat vce
quietly regress co2pcap gnppcap kgpcap
estimates store big
quietly regress co2pcap gnppcap
estimates store little
estimates dir
estimates describe big
estimates table big
lrtest big little
/*
	Odds and ends
*/
foreach name in co2pcap gnppcap kgppcap {
display "Current variable is `name'"
}
matrix define A = [1,2,3\4,5,6]
matrix list A


log close
exit

two connected kgpcap year, mlabel(year)
graph export JUSTSTATA_marker.eps, replace
tsset year
tsline gdp
graph export JUSTSTATA_tsline.eps, replace
