capture log close
log using ted, replace
/*
	TED spread
*/
use ${LOCAL_DATA}/daily/dailyrates, clear
describe otr3m libor3m
generate ted = 100*(libor3m - otr3m)	/* convert rates to basis points */
label variable ted "TED spread"
keep date year month day otr3m libor3m ted
keep if !missing(ted)
tsset date, daily
generate t = _n
tsset t, generic
ac ted if year<2008
ac D.ted if year<2008
ac D2.ted if year<2008
pac D.ted if year<2008
arima ted, arima(1,1,1) nolog
arima ted, arima(2,1,1) nolog
arima ted, arima(1,1,2)
arima ted, arima(1,1,1) nolog
predict resid, residual
wntestq resid
wntestq resid if year<1990, lags(20)
count if year<1990
wntestb resid

drop resid

generate lted = log(1+(ted/100))
ac lted if year<2008
ac D.lted if year<2008
ac D2.lted if year<2008
pac D.lted if year<2008
arima lted, arima(1,1,1) nolog
arima lted, arima(2,1,1) nolog
arima lted, arima(1,1,2)
arima lted, arima(1,1,1) nolog
predict resid, residual
wntestq resid
wntestq resid if year<1990, lags(20)
count if year<1990
wntestb resid

log close
