set more off
capture log close
log using var-1, replace
/*
	Construct quarterly inflation, unemployment, and Fed funds data

	Inflation first
*/
use ${ITSUS_DATA}/quarterly, clear
generate inflation = 400 * log(deflator/L.deflator) 
keep date inflation
format inflation %6.1f
tempfile temp
save `temp'
/*
	Now take quarterly averages of the unemployment and Fed funds rates
*/
use ${ITSUS_DATA}/monthly, clear
generate quarter = qofd(dofm(date))
format quarter %tqCCYY:q
collapse fedfunds unrate, by(quarter)
rename quarter date
tsset date, quarterly
merge 1:1 date using `temp'
drop if date<tq(1960q1)
keep date fedfunds unrate inflation
aorder
label data "Quarterly macroeconomic statistics for VAR examples"
label variable date Date
label variable fedfunds "Federal funds rate"
label variable inflation "Inflation"
label variable unrate "Civilian unemployment rate"
save ${ITSUS_DATA}/varexample, replace

/*
	Test of similarity to Stock and Watson results
*/
keep if date<tq(2001q1)
var inflation unrate fedfunds, lags(1/4)
vargranger
irf create swvar, set(swresults, replace) step(24)
irf table fevd, impulse(inflation unrate fedfunds) response(inflation)
irf table fevd, impulse(inflation unrate fedfunds) response(unrate)
irf table fevd, impulse(inflation unrate fedfunds) response(fedfunds)
irf graph oirf, impulse(inflation) response(inflation unrate fedfunds) name(inflation, replace)
irf graph oirf, impulse(unrate) response(inflation unrate fedfunds) name(unrate, replace)
irf graph oirf, impulse(fedfunds) response(inflation unrate fedfunds) name(fedfunds, replace)


log close
