set more off
clear
capture log close
log using var-2, replace
/*
	Unrestricted VAR
*/
use ${ITSUS_DATA}/varexample, clear
describe
tsset
local x = tq(2002q1) + 0.5
tsline inflation, xline(`x') ylabel(2 4 6 8 10 12) name(inflation, replace)
tsline unrate, xline(`x') ylabel(4 6 8 10) name(unrate, replace)
tsline fedfunds, xline(`x') ylabel(0 5 10 15) name(fedfunds, replace)
graph combine inflation unrate fedfunds
graph export VAR_data.eps, replace
summarize
summarize fedfunds inflation unrate if date<=tq(2002q1)
summarize fedfunds inflation unrate if date>tq(2002q1)
varsoc inflation unrate fedfunds if date<=tq(2002q1), maxlag(12)
varbasic inflation unrate fedfunds if date<=tq(2002q1), lags(1 2 3 4) step(12) nograph
varstable, graph
graph export VAR_eigen.eps, replace
varlmar
varnorm
varwle
test [unrate] : L1.inflation L2.inflation L3.inflation L4.inflation
vargranger

log close


