clear
set more off
capture log close
log using var-4, replace
/*
	Forecasts
*/
use ${ITSUS_DATA}/varexample, clear
quietly var inflation unrate fedfunds if date<=tq(2002q1), lags(1 2 3 4)
/*
	1-step-ahead conditional forecasts

	Inflation
*/
predict f_inflation
predict test1, equation(#1)
predict test2, equation(inflation)
summarize
label variable f_inflation "forecast"
compare f_inflation test1
compare f_inflation test2
drop test1 test2
compare inflation f_inflation if date>tq(2002q1)
tsline inflation f_inflation if date>tq(2002q1), lpattern(solid dash)
graph export /home/sls/itsus/eps/VAR_inflfore.eps, replace
predict r_inflation, equation(inflation) residuals
tsline r_inflation if date>tq(2002q1), yline(0)
graph export /home/sls/itsus/eps/VAR_inflres.eps, replace
sum r_inflation if date<=tq(2002q1)
sum r_inflation if date>tq(2002q1)
predict s_inflation, equation(inflation) stdp
generate l_inflation = f_inflation - 2*s_inflation
generate u_inflation = f_inflation + 2*s_inflation
twoway (rarea u_inflation l_inflation date, fintensity(inten10)) (line inflation f_inflation date, lpattern(solid dash)) in -40/l, yline(0) legend(order(2 3 1) label(1 "95% CI")) name(inflation, replace) 
*twoway (rarea u_inflation l_inflation date, fintensity(inten10)) (line inflation f_inflation date, lpattern(solid dash)) in -40/l, yline(0) legend(order(2 3 1) label(1 "95% CI")) name(inflation, replace) fysize(150) fxsize(75)
/*
	Unemployment rate
*/
predict f_unrate, equation(unrate)
label variable f_unrate "forecast"
tsline unrate f_unrate if date>tq(2002q1), lpattern(solid dash)
predict r_unrate, equation(unrate) residuals
sum unrate if date>tq(2002q1) & date<tq(2008q1)
sum unrate if date>tq(2008q4)
compare unrate f_unrate if date>tq(2002q1)
tsline r_unrate, yline(0)
sum r_unrate if date<=tq(2002q1)
sum r_unrate if date>tq(2002q1)
predict s_unrate, equation(unrate) stdp
generate l_unrate = f_unrate - 2*s_unrate
generate u_unrate = f_unrate + 2*s_unrate
label variable unrate "Unemp. rate"
twoway (rarea u_unrate l_unrate date, fintensity(inten10)) (line unrate f_unrate date, lpattern(solid dash)) in -40/l, legend(order(2 3 1) label(1 "95% CI")) name(unrate, replace) 
*twoway (rarea u_unrate l_unrate date, fintensity(inten10)) (line unrate f_unrate date, lpattern(solid dash)) in -40/l, legend(order(2 3 1) label(1 "95% CI")) name(unrate, replace) fysize(150) fxsize(75)
/*
	Fed funds
*/
predict f_fedfunds, equation(fedfunds)
label variable f_fedfunds "forecast"
tsline fedfunds f_fedfunds if date>tq(2002q1), lpattern(solid dash)
predict r_fedfunds, equation(fedfunds) residuals
compare fedfunds f_fedfunds if date>tq(2002q1)
tsline r_fedfunds, yline(0)
sum r_fedfunds if date<=tq(2002q1)
sum r_fedfunds if date>tq(2002q1)
predict s_fedfunds, equation(fedfunds) stdp
generate l_fedfunds = f_fedfunds - 2*s_fedfunds
generate u_fedfunds = f_fedfunds + 2*s_fedfunds
twoway (rarea u_fedfunds l_fedfunds date, fintensity(inten10)) (line fedfunds f_fedfunds date, lpattern(solid dash)) in -40/l, yline(0) legend(order(2 3 1) label(1 "95% CI")) name(fedfunds, replace) 
*twoway (rarea u_fedfunds l_fedfunds date, fintensity(inten10)) (line fedfunds f_fedfunds date, lpattern(solid dash)) in -40/l, yline(0) legend(order(2 3 1) label(1 "95% CI")) name(fedfunds, replace) fysize(150) fxsize(75)
graph combine inflation unrate fedfunds
*graph combine inflation unrate fedfunds, cols(1) ysize(7)
graph export /home/sls/itsus/eps/VAR_condfore.eps, replace
/*
	Dynamic forecasts
*/
fcast compute F_, step(40)
fcast graph F_inflation F_unrate F_fedfunds, observed lpattern(dash)
graph export /home/sls/itsus/eps/VAR_dynfore.eps, replace
describe F_infl*
list date inflation F_inflation if date>tq(1999q4) & date<tq(2003q1)
fcast compute Z_, step(40) dynamic(tq(2000q3))
describe Z_*
list date inflation F_inflation Z_inflation if date>tq(2000q4) & date<tq(2003q1)
/*
	Compare 1-step-ahead to dynamic forecasts
*/
two (rarea F_inflation_UB F_inflation_LB date, fintensity(inten10)) (line inflation f_inflation F_inflation date, lpattern(solid dash shortdash)) in -40/l, legend(order(2 3 4 1) label(1 "95% CI") label(3 "1-step") label(4 "Dynamic")) name(compinfl, replace)
two (rarea F_unrate_UB F_unrate_LB date, fintensity(inten10)) (line unrate f_unrate F_unrate date, lpattern(solid dash shortdash)) in -40/l, legend(order(2 3 4 1) label(1 "95% CI") label(3 "1-step") label(4 "Dynamic")) name(compunra, replace)
two (rarea F_fedfunds_UB F_fedfunds_LB date, fintensity(inten10)) (line fedfunds f_fedfunds F_fedfunds date, lpattern(solid dash shortdash)) in -40/l, legend(order(2 3 4 1) label(1 "95% CI") label(3 "1-step") label(4 "Dynamic")) name(compfedfu, replace)
graph combine compinfl compunra compfedfu
graph export /home/sls/itsus/eps/VAR_compfore.eps, replace

log close
