clear
set more off
capture log close
log using var-5, replace
/*
	IRFs
*/
capture erase macrovar.irf
use ${ITSUS_DATA}/varexample, clear

/*
	IUF ordering
*/

quietly var inflation unrate fedfunds if date<=tq(2002q1), lags(1 2 3 4)
irf create iuf, set(macrovar) step(20)
describe using macrovar.irf

irf table oirf
irf table oirf, impulse(inflation) response(unrate)
irf table oirf, noci impulse(inflation)
irf table fevd, noci response(inflation) title(FEVD of inflation)
irf table fevd, noci response(unrate) title(FEVD of unrate)
irf table fevd, noci response(fedfunds) title(FEVD of fedfunds)

irf graph oirf, yline(0)
graph export VAR_irfgph.eps, replace

/*
	FUI ordering and comparisons with IUF
*/

irf create fui, order(fedfunds unrate inflation) step(20)
irf cgraph (iuf fedfunds inflation oirf) (fui fedfunds inflation oirf) (iuf fedfunds unrate oirf) (fui fedfunds unrate oirf), noci yline(0) ylabel(-.2 -.1 0 .1 .2) legend(off)
graph export VAR_oirf.eps, replace
irf cgraph (iuf fedfunds inflation coirf) (fui fedfunds inflation coirf) (iuf fedfunds unrate coirf) (fui fedfunds unrate coirf), noci yline(0) ylabel(-2 -1 0 1 2) legend(off)
graph export VAR_coirf.eps, replace
irf cgraph (iuf fedfunds inflation fevd, ylabel(0 0.05 .1)) (fui fedfunds inflation fevd, ylabel(0 0.05 .1)) (iuf fedfunds unrate fevd, ylabel(0 .1 .2 .3)) (fui fedfunds unrate fevd, ylabel(0 .1 .2 .3)), noci legend(off)
graph export VAR_fevd.eps, replace

log close

