clear
set more off
capture log close
log using var-6, replace
/*
	Structural VAR

	Short-run SVAR => recursive VAR
*/
constraint drop _all
capture erase fui.ster
capture erase svar.irf
use ${ITSUS_DATA}/varexample, clear
quietly var fedfunds unrate inflation if date<=tq(2002q1), lags(1 2 3 4) 
estimates save fui
irf create fui, set(svar) step(20)
matrix A = [1,0,0\.,1,0\.,.,1]
matrix B = [.,0,0\0,.,0\0,0,.]
matrix list A
matrix list B
svar fedfunds unrate inflation if date<=tq(2002q1), lags(1 2 3 4) aeq(A) beq(B) 
irf create svar, set(svar) step(20)
irf cgraph (fui fedfunds inflation oirf) (svar fedfunds inflation sirf), legend(off)
graph export VAR_exact.eps, replace
/*
	Overidentifying restrictions (don't use)
*/
matrix A = [1,0,0\.,1,0\.,0,1]
matrix list A
svar fedfunds unrate inflation if date<=tq(2002q1), lags(1 2 3 4) aeq(A) beq(B) 
constraint 1 [fedfunds]L4.fedfunds = 0
constraint 2 [fedfunds]L3.unrate = 0
constraint 3 [fedfunds]L3.inflation = 0
svar fedfunds unrate inflation if date<=tq(2002q1), lags(1 2 3 4) aeq(A) beq(B) varconst(1/3) var
/*
	Backward-looking Taylor rule
*/
matrix A = [1,0,0\0,1,.\0,.,1]
local a = 1.5/4
local b = -1.25/4
constraint 1 [fedfunds]L.inflation=`a'
constraint 2 [fedfunds]L2.inflation=`a'
constraint 3 [fedfunds]L3.inflation=`a'
constraint 4 [fedfunds]L4.inflation=`a'
constraint 5 [fedfunds]L.unrate=`b'
constraint 6 [fedfunds]L2.unrate=`b'
constraint 7 [fedfunds]L3.unrate=`b'
constraint 8 [fedfunds]L4.unrate=`b'
svar fedfunds unrate inflation if date<=tq(2002q1), lags(1 2 3 4) aeq(A) varconst(1/8)
irf create taylor, set(svar) step(20)
irf cgraph (fui fedfunds inflation oirf) (taylor fedfunds inflation sirf) (fui fedfunds unrate oirf) (taylor fedfunds unrate sirf), noci

log close
