clear
set more off
capture log close
log using var-7, replace

use ${ITSUS_DATA}/varexample, clear

xcorr unrate inflation if date<=tq(2002q1), name(left, replace)
xcorr inflation unrate if date<=tq(2002q1), name(right, replace)
graph combine left right, name(leftright, replace)
graph export VAR_leftright.eps, replace

correlate inflation L10.inflation unrate L10.unrate if date<=tq(2002q1)

xcorr unrate inflation if date<=tq(2002q1), table
xcorr unrate inflation if date<=tq(2002q1), lags(12) yline(0) name(ui, replace) yscale(range(-1 1)) ylabel(-1 1) ylabel(none, axis(2)) ytitle("") title(Unemployment and inflation) t2title(1960q1 - 2002q1)
xcorr unrate inflation if date<tq(1985q1), lags(12) yline(0) name(uiearly, replace) yscale(range(-1 1)) ylabel(-1 1) ylabel(none, axis(2)) ytitle("") title(Unemployment/inflation) t2title(1960q1 - 1984q4)
xcorr unrate inflation if date>=tq(1985q1) & date<=tq(2002q1), lags(12) yline(0) name(uilate, replace) yscale(range(-1 1)) ylabel(-1 1) ylabel(none, axis(2)) ytitle("") title("") t2title(1985q1 - 2002q1)
xcorr unrate inflation if date>tq(2002q1), lags(12) yline(0) name(uiout, replace) yscale(range(-1 1)) ylabel(-1 1) ylabel(none, axis(2)) ytitle("") title("") t2title(2002q2 - 2012q1)

xcorr inflation fedfunds if date<=tq(2002q1), lags(12) yline(0) name(ife, replace) yscale(range(-1 1)) ylabel(none) ylabel(none, axis(2)) ytitle("") title(Inflation and Federal funds) t2title(1960q1 - 2002q1)
xcorr inflation fedfunds if date<tq(1985q1), lags(12) yline(0) name(ifeearly, replace) yscale(range(-1 1)) ylabel(none) ylabel(none, axis(2)) ytitle("") title(Inflation/Federal funds) t2title(1960q1 - 1984q4)
xcorr inflation fedfunds if date>=tq(1985q1) & date<=tq(2002q1), lags(12) yline(0) name(ifelate, replace) yscale(range(-1 1)) ylabel(none) ylabel(none, axis(2)) ytitle("") title("") t2title(1985q1 - 2002q1)
xcorr inflation fedfunds if date>tq(2002q1), lags(12) yline(0) name(ifeout, replace) yscale(range(-1 1)) ylabel(none) ylabel(none, axis(2)) ytitle("") title("") t2title(2002q2 - 2012q1)

xcorr unrate fedfunds if date<=tq(2002q1), lags(12) yline(0) name(uf, replace) yscale(range(-1 1)) ylabel(none) ylabel(none, axis(2)) ytitle("") title(Unemployment and Federal funds) t2title(1960q1 - 2002q1)
xcorr unrate fedfunds if date<tq(1985q1), lags(12) yline(0) name(ufearly, replace) yscale(range(-1 1)) ylabel(none) ylabel(none, axis(2)) ytitle("") title(Unemployment/Federal funds) t2title(1960q1 - 1984q4)
xcorr unrate fedfunds if date>=tq(1985q1) & date<=tq(2002q1), lags(12) yline(0) name(uflate, replace) yscale(range(-1 1)) ylabel(none) ylabel(none, axis(2)) ytitle("") title("") t2title(1985q1 - 2002q1)
xcorr unrate fedfunds if date>tq(2002q1), lags(12) yline(0) name(ufout, replace) yscale(range(-1 1)) ylabel(none) ylabel(none, axis(2)) ytitle("") title("") t2title(2002q2 - 2012q1)

graph combine uiearly ufearly ifeearly uilate uflate ifelate uiout ufout ifeout, rows(4) 
graph export VAR_combxcorr.eps, replace

log close
