clear
set more off
capture log close
log using var-8, replace
/*
	Backward-looking Taylor rule
*/
constraint drop _all
capture erase iuf.ster
capture erase svar.irf
use ${ITSUS_DATA}/varexample, clear
quietly var inflation unrate fedfunds if date<=tq(2002q1), lags(1 2 3 4) 
estimates save iuf
irf create iuf, set(svar) step(20)
fcast compute RF_, step(40)
matrix A = [1,.,0\.,1,0\0,0,1]
*matrix A = [1,0,0\0,1,.\0,.,1]
matrix list A
constraint 1 [fedfunds]L.inflation  = 1.5/4
constraint 2 [fedfunds]L2.inflation = 1.5/4
constraint 3 [fedfunds]L3.inflation = 1.5/4
constraint 4 [fedfunds]L4.inflation = 1.5/4
constraint 5 [fedfunds]L.unrate  = -1.25/4
constraint 6 [fedfunds]L2.unrate = -1.25/4
constraint 7 [fedfunds]L3.unrate = -1.25/4
constraint 8 [fedfunds]L4.unrate = -1.25/4
svar inflation unrate fedfunds if date<=tq(2002q1), lags(1 2 3 4) aeq(A) varconst(1/8) noislog
irf create taylor, step(20)
irf cgraph (iuf fedfunds unrate oirf, plot1(ylabel(0 0.05 0.10 0.15)))  ///
           (taylor fedfunds unrate sirf, plot1(ylabel(-0.4 -0.2 0 0.2))) ///
           (iuf fedfunds inflation oirf, plot1(ylabel(-0.2 -0.1 0 0.1))) ///
           (taylor fedfunds inflation sirf, plot1(ylabel(-0.6 -0.3 0 0.3))), ///
           noci yline(0) legend(off)
graph export VAR_taylor.eps, replace
svar inflation unrate fedfunds if date>tq(2002q1), lags(1 2 3 4) aeq(A) varconst(1/8) noislog
irf create later, step(20)
irf cgraph (taylor fedfunds unrate sirf, plot1(ylabel(-0.4 -0.2 0 0.2))) ///
           (later fedfunds unrate sirf, plot1(ylabel(-1.5 -1 -0.5 0)))   ///
           (taylor fedfunds inflation sirf, plot1(ylabel(-0.6 -0.3 0 0.3))) ///
           (later fedfunds inflation sirf, plot1(ylabel(-5 -2.5 0 2.5 5))), ///
           noci yline(0) legend(off)
graph export VAR_later.eps, replace
/*
	The Gustavo Sanchez approach
*/
tssmooth ma umean = unrate, window(4 0 0)
tssmooth ma imean = inflation, window(4 0 0)
generate taylor = fedfunds - 1.5*imean + 1.25*umean
var inflation unrate taylor if date<=tq(2002q1), lags(1 2 3 4)
irf create gustavo, step(20)
/*
	And a variant on Gustavo's method
*/
var inflation unrate fedfunds if date<=tq(2002q1), exog(taylor) lags(1 2)
irf create g2, step(20)

log close
