*!  version 4.0.0 \ jsl 2007-08-05

//  syntax:     nmlabel <list of variables>
//  version:    4 - add flexible columns
//  task:       list variable names and labels
//  project:    workflow chapter 4
//  author:     scott long \ 2007-08-05

capture program drop nmlabel
program define nmlabel
    version 10
    syntax varlist [, skip NUMber COLnum(integer 10)]
    if "`skip'"=="skip" {
        display
    }
    local varnumber = 0
    foreach varname in `varlist' {
        local ++varnumber
        local varlabel :  variable label `varname'
        if "`number'"=="" { // do not number lines
            display in yellow "`varname'" _col(`colnum') "`varlabel'"
        }
        else { // number lines
            local colnumplus2 = `colnum' + 2
            display in green "#`varnumber': " ///
                in yellow "`varname'" _col(`colnumplus2') "`varlabel'"
        }
    }
end
exit
