capture log close
log using wf3-debug-graph7, replace text

//  program:    wf3-debug-graph7.do
//  task:       debugging example of graph command
//              step 7 - change xlabel(1,5) to xlabel(1(1)5)
//  project:    workflow - chapter 3
//  author:     scott long \ 2008-04-09

//  #0
//  setup

version 10
set linesize 80
clear all
macro drop _all

//  #1
//  load data

use wf-acjob, clear

//  #2
//  create graph

twoway (scatter job phd, msymbol(smcircle_hollow) msize(small)),     ///
    ytitle(Where do you work?) yscale(range(1 5.))                   ///
    ylabel(1(1)5, angle(ninety))                                     ///
    xtitle(Where did you graduate?) xscale(range(1 5)) xlabel(1(1)5) ///
    caption(wf3-debug-graph7.do 2008-04-09, size(small))              ///
    scheme(s2manual) aspectratio(1) by(fem)

log close
exit
