capture log close
log using wf3-debug-precision, replace text

//  program:    wf3-debug-precision.do
//  task:       error caused by insufficient precision
//  project:    workflow - chapter 3
//  author:     scott long \ 2008-04-09

//  #0
//  setup

version 10
set linesize 80
clear all
macro drop _all

//  #1
//  load data and look at basic information

use wf-flims, clear
summarize hnd hvy lft rch sit std stp str wlk

//  #2
//  combining two variables

generate strwlk = 10*str + wlk
tabulate strwlk, missing

//  #2
//  create variable containing all limitations

generate flimall = hnd*100000000 + hvy*10000000 + lft*1000000 ///
    + rch*100000 + sit*10000 + std*1000 + stp*100 + str*10 + wlk
label var flimall "hnd-hvy-lft-rch-sit-std-stp-str-wlk"
tabulate flimall, missing

//  #3
//  create a string version of all limitations

generate  sflimall=string(flimall, "%16.0f")
label var sflimall "hnd-hvy-lft-rch-sit-std-stp-str-wlk"
tabulate  sflimall, missing

//  #4
//  make the code easier to debug

use wf-flims, clear
generate flimall = hnd*100000000 ///
                 + hvy*10000000 ///
                 + lft*1000000 ///
                 + rch*100000 ///
                 + sit*10000 ///
                 + std*1000 ///
                 + stp*100 ///
                 + str*10 ///
                 + wlk
label var flimall "hnd-hvy-lft-rch-sit-std-stp-str-wlk"

//  #5
//  try a simpler example and make it easier to read

use wf-flims, clear
generate flimall = std*1000 ///
                 + stp*100 ///
                 + str*10 ///
                 + wlk
generate  sflimall=string(flimall,"%9.0f")
label var sflimall "std-stp-str-wlk"
tabulate  sflimall, missing

//  #6
//  keep adding one at a time till it breaks

use wf-flims, clear
generate flimall = hvy*10000000 ///
            + lft*1000000 ///
            + rch*100000 ///
            + sit*10000 ///
            + std*1000 ///
            + stp*100 ///
            + str*10 ///
            + wlk
generate  sflimall = string(flimall,"%09.0f")
label var sflimall "hvy-lft-rch-sit-std-stp-str-wlk"
tabulate  sflimall, missing

//  #7
//  look at a value that is a problem

list if sflimall == "111111112", clean

//  #8
//  fix the problem by using higher precisions

use wf-flims, clear
generate double flimall = hnd*100000000 ///
                        + hvy*10000000 ///
                        + lft*1000000 ///
                        + rch*100000 ///
                        + sit*10000 ///
                        + std*1000 ///
                        + stp*100 ///
                        + str*10 ///
                        + wlk
generate sflimall = string(flimall,"%09.0f")
tabulate sflimall, missing

//  #9 - additional material
//  here is an alternative approach that only uses strings

use wf-flims, clear
foreach v in hnd hvy lft rch sit std stp str wlk {
    generate s`v' = string(`v',"%1.0f")
}
generate sflimall = shnd + shvy + slft + srch + ssit ///
    + sstd + sstp + sstr + swlk
    label var sflimall "hnd-hvy-lft-rch-sit-std-stp-str-wlk"
tabulate sflimall, missing

log close
exit
