capture log close
log using wf3-subsample, replace text

//  program:    wf3-subsample.do
//  task:       debugging with a small sample
//  project:    workflow - chapter 3
//  author:     scott long \ 2008-10-18

//  note:       uniform() was replaced runiform() in Stata 10.1

//  #0
//  setup

version 10.1
set linesize 80
clear all
macro drop _all

//  #1
//  load data

use wf-lfp, clear

//  #2
//  create a small random sample

set seed 11020
generate isin = (runiform()>.8)
label var isin "1 if in random sample (seed 11020)"
label def isin 0 0_NoIn 1 1_InSample
label val isin isin
keep if isin
tabulate isin, missing

//  #3
//  save the subsample

label data "20% subsample of wf-lfp."
note: wf3-subsample.do jsl 2008-10-18.
save x-wf3-subsample, replace

//  #4
//  try command using subsample

logit  lfp k5 k618 age wc hc lwg inc

log close
exit
