capture log close
log using wf4-include, replace text

//  program:    wf4-include.do
//  include:    requires wf4-include-2digit-recode.doi
//              & wf4-include-3digit-recode.doi
//  task:       examples of include command
//  project:    workflow chapter 4
//  author:     scott long \ 2008-04-09

//  #0
//  setup

version 10
set linesize 80
clear all
macro drop _all

//  #1
//  recode variables without include and without loops

use wf-include, clear

// recode two digit missing values

* inneighb: recode 97, 98 & 99
clonevar inneighbR = inneighb
replace  inneighbR = .a if inneighbR==97
replace  inneighbR = .b if inneighbR==98
replace  inneighbR = .c if inneighbR==99
tabulate inneighb inneighbR, miss nolabel
* insocial: recode 97, 98 & 99
clonevar insocialR = insocial
replace  insocialR = .a if insocialR==97
replace  insocialR = .b if insocialR==98
replace  insocialR = .c if insocialR==99
tabulate insocial insocialR, miss nolabel
* inchild:  recode 97, 98 & 99
clonevar inchildR = inchild
replace  inchildR = .a if inchildR==97
replace  inchildR = .b if inchildR==98
replace  inchildR = .c if inchildR==99
tabulate inchild inchildR, miss nolabel
* infriend: recode 997 998 999
clonevar infriendR = infriend
replace  infriendR = .a if infriendR==97
replace  infriendR = .b if infriendR==98
replace  infriendR = .c if infriendR==99
tabulate infriend infriendR, miss nolabel

// recode three digit missing values

* inmarry:  recode 997 998 999
clonevar inmarryR = inmarry
replace  inmarryR = .a if inmarryR==997
replace  inmarryR = .b if inmarryR==998
replace  inmarryR = .c if inmarryR==999
tabulate inmarry inmarryR, miss nolabel
* inwork:   recode 997 998 999
clonevar inworkR = inwork
replace  inworkR = .a if inworkR==997
replace  inworkR = .b if inworkR==998
replace  inworkR = .c if inworkR==999
tabulate inwork inworkR, miss nolabel

//  #2
//  recode variables without include using a loop

use wf-include, clear

// recode two digit missing values

foreach varname in inneighb insocial inchild infriend {
    clonevar `varname'R = `varname'
    replace  `varname'R = .a if `varname'R==97
    replace  `varname'R = .b if `varname'R==98
    replace  `varname'R = .c if `varname'R==99
    tabulate `varname' `varname'R, miss nolabel
}

// recode three digit missing values

foreach varname in inmarry inwork {
    clonevar `varname'R = `varname'
    replace  `varname'R = .a if `varname'R==997
    replace  `varname'R = .b if `varname'R==998
    replace  `varname'R = .c if `varname'R==999
    tabulate `varname' `varname'R, miss nolabel
}

//  #3
//  recode variables with include

use wf-include, clear

// recode two digit missing values

local varname inneighb
    include wf4-include-2digit-recode.doi
local varname insocial
    include wf4-include-2digit-recode.doi
local varname inchild
    include wf4-include-2digit-recode.doi
local varname infriend
    include wf4-include-2digit-recode.doi

// recode three digit missing values

local varname inmarry
    include wf4-include-3digit-recode.doi
local varname inwork
    include wf4-include-3digit-recode.doi

log close
exit
