capture log close
log using wf5-datasignature, replace text

//  program:    wf5-datasignature.do
//  task:       using datasignature
//  project:    workflow chapter 5
//  author:     scott long \ 2008-04-09

//  !! note !!  This do-file generates errors when the datasignature has
//              changed. Normally, this will terminate the do-file.
//              To allow the do-file to complete even with errors, run
//              the file as: do wf5-datasignature, nostop

//  !! note !!  This do-file will not work in Stata 9 or earlier.

//  #0
//  setup

version 10
set linesize 80
clear all
macro drop _all

//  #1
//  load data and create locals

use wf-datasig01, clear
describe, simple
local date "2008-04-09"
local tag "wf5-datasignature.do jsl `date'."

//  #2
//  various datasignature commands and options

* compute the signature
datasignature

* compute and store the signature
datasignature set
note: wf-datasig02.dta \ add signature \ `tag'
label data "Workflow dataset for illustrating datasignature \ `date'"
save wf-datasig02, replace

* load data and confirm signature
use wf-datasig02, clear
* since the dataset has not changed, the signature is confirmed
datasignature confirm

* change the name of k5
use wf-datasig02, clear
rename k5 kids5
* incorrectly, this is saved with the same dataset name
label data "Workflow data for illustrating datasignature \ `date'"
save wf-datasig02, replace
* load the dataset
use wf-datasig02, clear
* the signature is not confirmed since the data was changed
datasignature confirm

log close
exit
