capture log close
log using wf5-sgc2a-clone, replace text

//  program:    wf5-sgc2a-clone.do
//  task:       make clones of existing variables
//  project:    workflow chapter 5 - sgc renaming and relabeling example
//  author:     scott long \ 2008-04-09

//  #0
//  setup

version 10
set linesize 80
clear all
macro drop _all

//  #1
//  create locals

local date "2008-04-09"
local tag "wf5-sgc2a.do jsl `date'"

//  #2
//  load data

use wf-sgc-source, clear
datasignature confirm
notes _dta

//  #3
//  loop through variables and create clones

unab varlist : _all
foreach varname in `varlist' {
    clonevar S`varname' = `varname'
    note S`varname': Source variable for `varname' \ `tag'
    note  `varname': Clone of source variable S`varname' \ `tag'
}

//  #4
//  check the variables

codebook, compact

//  #5
//  closeup and save data

quietly compress
note: wf-sgc01.dta \ create clones of source variables \ `tag'
label data "Workflow data for SGC renaming example \ `date'"
datasignature set, reset
save wf-sgc01, replace

* check the dataset
use wf-sgc01, clear
datasignature confirm
note _dta

log close
exit
