capture log close
log using wf5-sgc2b-rename-dump, replace text

//  program:    wf5-sgc2b-rename-dump.do
//  task:       create dummy rename commands
//  project:    workflow chapter 5 - sgc renaming and relabeling example
//  author:     scott long \ 2008-04-09

//  #0
//  setup

version 10
set linesize 80
clear all
macro drop _all

//  #1
//  load data

use wf-sgc01, clear
datasignature confirm
notes _dta

//  #2
//  drop the source variables that will not be renamed & sort names

* drop S(ource) variables since they will not be renamed
drop S*

* create an alphabetized list of the non-S varaibles
aorder

//  #3
//  loop through the names and create baseline rename commands

unab varlist : _all
file open myfile using wf5-sgc2b-rename-dummy.doi, write replace

foreach varname in `varlist' {
    file write myfile "*rename  `varname'" _col(22) "`varname'" _newline
}
file close myfile

log close
exit
