capture log close
log using wf5-sgc2c-rename, replace text

//  program:    wf5-sgc2c-rename.do
//  include:    wf5-sgc2b-rename-revised.doi
//  task:       rename variables using commands generated in step3a.
//  project:    workflow chapter 5 - sgc renaming and relabeling example
//  author:     scott long \ 2008-04-09

//  #0
//  setup

version 10
set linesize 80
clear all
macro drop _all

//  #1
//  define locals

local date "2008-04-09"
local tag "wf5-sgc2c.do jsl `date'."

//  #2
//  load the data

use wf-sgc01, clear
datasignature confirm
notes _dta

//  #3
//  include the edited rename commands

include wf5-sgc2b-rename-revised.doi

//  #4
//  closeup and save data

quietly compress
note: wf-sgc02.dta \ rename source variables \ `tag'
label data "Workflow data for SGC renaming example \ `date'"
datasignature set, reset
save wf-sgc02, replace

* check data
use wf-sgc02, clear
datasignature confirm
notes _dta

//  #5
//  check new names

set linesize 120
nmlab

log close
exit
