capture log close
log using wf5-sgc4a-vallab-check, replace text

//  program:    wf5-sgc4a-vallab-check.do
//  task:       check the value labels currently being used
//  project:    workflow chapter 5 - sgc renaming and relabeling example
//  author:     scott long \ 2008-04-09

//  #0
//  setup

version 10
set linesize 80
clear all
macro drop _all

//  #1
//  load data

use wf-sgc03, clear
datasignature confirm
notes _dta

//  #2
//  inventory of existing value labels

labelbook `valdeflist', length(10)

//  #3 - not in book
//  get list of value labels

* get list of non-S variables
drop S*
unab varlist : _all

* define local to hold list of label definitions
local valdeflist ""

* loop through variables and add value label names to valdeflist
foreach varname in `varlist' {
    local vallabel : value label `varname'
    local valdeflist "`valdeflist' `vallabel'"
}

* list of value labels with duplicates
display "`valdeflist'"

* remove duplicates
local valdeflist : list uniq valdeflist
display "`valdeflist'"

log close
exit
