capture log close
log using wf5-sgc5a-check, replace text

//  program:    wf5-sgc5a-check.do
//  task:       step 5a: check new names and labels
//  project:    workflow chapter 5 - sgc renaming and relabeling example
//  author:     scott long \ 2008-04-09

//  #0
//  setup

version 10
set linesize 80
clear all
macro drop _all

//  #1
//  load data

use wf-sgc04, clear
datasignature confirm

//  #2
//  examine value labels using tabulate

drop id_iu cntry_iu age S*
unab varlist : _all

label language default

foreach varname in `varlist' {
    display "`varname':"
    tab gender `varname', missing
}

log close
exit
