capture log close
log using wf6-merge-match, replace text

//  program:    wf6-merge-match.do
//  task:       Example of match merging
//  project:    workflow chapter 6
//  author:     scott long \ 2008-04-09

//  #0
//  setup

version 10
set linesize 80
clear all
macro drop _all

//  #1
//  define local

local date "2008-04-09"
local tag "wf6-merge-match.do jsl `date'."

//  #2
//  check signatures ande load the master dataset

use wf-nls-flim05, clear
datasignature confirm

use wf-nls-cntrl07, clear
datasignature confirm

//  #3
//  merge in the flim dataset and check variables

merge id using wf-nls-flim05
tab1 _merge
drop _merge
codebook, compact

//  #4
//  check variables and save merged file

quietly compress
label data "Workflow merged NLS flim & control variables \ `date'"
note: wf-nls-combined01.dta \ workflow data for chapter 6 \ `tag'
datasignature set, reset
save wf-nls-combined01, replace

use wf-nls-combined01, clear
datasignature confirm
notes
codebook, compact
datasignature confirm

//  #5
//  sorting before merging

use wf-nls-cntrl07, clear
datasignature confirm
merge id using wf-nls-flim05, sort

log close
exit
