capture log close
log using wf7-baseline, replace text

//  pgm:        wf7-baseline.do
//  task:       tenure - baseline statistics
//  project:    workflow chapter 7
//  author:     scott long \ 2008-04-09

//  #0
//  setup

version 10
set linesize 80
clear
macro drop _all

//  #1
//  load data and select sample

use wf-tenure, clear
datasignature confirm
tabulate sampleis
keep if sampleis

//  #2
//  desc statistics for men & women combined

codebook female male tenure year yearsq select articles prestige, compact

//  #3
//  desc statistics for women

codebook female male tenure year yearsq select articles prestige ///
    if female, compact

//  #4
//  desc statistics for men

codebook female male tenure year yearsq select articles prestige ///
    if male, compact

log close
exit
