capture log close
log using wf7-loops-ttest, replace text

//  pgm:        wf7-loops-ttest.do
//  task:       using loops for t-tests
//  project:    workflow chapter 7
//  author:     scott long \ 2008-04-09

//  #0
//  setup

version 10
set linesize 80
clear
macro drop _all

//  #1
//  load data and select sample

use wf-tenure, clear
datasignature confirm
tabulate sampleis
keep if sampleis

//  #2
//  ttest gender differences without a loop

ttest tenure,   by(female)
ttest year,     by(female)
ttest select,   by(female)
ttest articles, by(female)
ttest prestige, by(female)

//  #3
//  ttest gender differences using a loop with no header

local varlist "tenure year select articles prestige"
foreach var in `varlist' {
    ttest `var', by(female)
}

//  #4
//  ttest gender differences using a loop with a header

local varlist "tenure year select articles prestige"
foreach var in `varlist' {
    * echo command
    di _new ". ttest `var', by(female)"
    ttest `var', by(female)
}

log close
exit
