capture log close
log using wf7-replicate-setseed, replace text

//  pgm:        wf7-replicate-setseed.do
//  task:       letting stata set the seed
//  project:    workflow chapter 7
//  author:     scott long \ 2008-10-18

//  note:       must be run immediately after starting Stata
//              uniform() was replaced by runiform() in Stata 10.1

//  #0
//  setup

version 10.1
set linesize 80
clear
macro drop _all

//  #1
//  set # of observations

set obs 100

//  #2
//  check the seed stata automatically set

creturn list
local seedis = c(seed)
di "`seedis'"

//  #3
//  generate random numbers with this seed

gen u1 = runiform()
sum u1

//  #4
//  generate random numbers based on seed set by stata initially

gen u2 = runiform()
sum u2

//  #5
//  generate random numbers with a seed I pick

set seed 1102
gen u3 = runiform()
sum u3

//  #6
//  generate random numbers with seed saved above

set seed `seedis'
gen u4 = runiform()
pwcorr u1 u2 u3 u3 u4

log close
exit
